<?php

namespace App\Http\Resources;

use App\Models\Notification;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use JsonSerializable;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        /** @var Notification|JsonResource $this */

        return [
            'id'            => $this->when($this->id, $this->id),
            'type'          => $this->when($this->type, $this->type),
            'payload'       => $this->when($this->payload, $this->payload),
            'created_at'    => $this->when($this->created_at, $this->created_at?->format('Y-m-d H:i:s') . 'Z'),
            'updated_at'    => $this->when($this->updated_at, $this->updated_at?->format('Y-m-d H:i:s') . 'Z'),
        ];
    }
}
