import 'package:flutter/material.dart';
import '../../domain/di/injection.dart';
import '../../domain/handlers/handlers.dart';
import '../../domain/interface/shops_repository.dart';
import '../models/data/address_data.dart';
import '../services/services.dart';
import 'package:dio/dio.dart';

class ShopsRepositoryImpl implements ShopsRepository {


  @override
  Future<ApiResult<void>> createShop({
    required double tax,
    required double deliveryTo,
    required double deliveryFrom,
    required String deliveryType,
    required String phone,
    required String name,
    required num category,
    required String description,
    required double startPrice,
    required double perKm,
    required AddressData address,
    String? logoImage,
    String? backgroundImage,
  }) async {

    final data = {
      "open" : true,
      "price_per_km": perKm,
      'tax': tax,
      //'categories[0]': category,
      'delivery_time_type': deliveryType,
      'location': '${address.location?.latitude},${address.location?.longitude}',
      'phone': phone,
      'delivery_time_from': deliveryFrom,
      'delivery_time_to': deliveryTo,
      'title': {LocalStorage.instance.getLanguage()?.locale ?? "": name},
      'description': {LocalStorage.instance.getLanguage()?.locale ?? "": description},
      'price': startPrice,
      'address': {
        LocalStorage.instance.getLanguage()?.locale ?? "":
        "${address.title}, ${address.address}"
      },
      if (logoImage != null) 'images[0]': logoImage,
      if (backgroundImage != null) "images[1]": backgroundImage,
    };
    try {
      final client = inject<HttpService>().client(requireAuth: true);
      await client.post(
        '/api/v1/dashboard/user/shops',
        queryParameters: data,
      );
      return const ApiResult.success(data: null);
    } catch (e) {
      debugPrint('==> create shop failure: $e');
      return ApiResult.failure(error: (e.runtimeType == DioError)
          ? ((e as DioError).response?.data["message"] == "Bad request."
          ? (e.response?.data["params"] as Map).values.first[0]
          : e.response?.data["message"])
          : "", statusCode: NetworkExceptions.getDioStatus(e));

    }
  }


}
