<?php

namespace App\Http\Requests\Admin\DeliveryZone;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'address'       => 'array|required',
            'address.*'     => 'array|required',
            'address.*.*'   => 'numeric|required',
            'shop_id'       => [
                'required',
                Rule::exists('shops', 'id')->whereNull('deleted_at')
            ],
        ];
    }
}
