import 'package:auto_route/auto_route.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:venderfoodyman/infrastructure/models/data/location_data.dart';

import '../../infrastructure/models/data/address_data.dart';
import '../../infrastructure/services/services.dart';
import '../component/components.dart';
import '../routes/app_router.gr.dart';
import '../styles/style.dart';

class AddAddress extends StatelessWidget {
  const AddAddress({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: [
        Text(
          AppHelpers.trans(TrKeys.approved),
          style: Style.interSemi(size: 16.sp),
          textAlign: TextAlign.center,
        ),
        24.verticalSpace,
        Row(
          children: [
            Expanded(
              child: CustomButton(
                  title: AppHelpers.trans(TrKeys.cancel),
                  borderColor: Style.blackColor,
                  background: Style.transparent,
                  onPressed: () {
                    Navigator.pop(context);
                    context.pushRoute(ViewMapRoute(onChanged: () {}));
                  }),
            ),
            24.horizontalSpace,
            Expanded(
              child: Consumer(builder: (context, ref, child) {
                return CustomButton(
                    title: AppHelpers.trans(TrKeys.yes),
                    onPressed: () {
                      Navigator.pop(context);
                      LocalStorage.setAddressSelected(
                        AddressData(
                            location: LocationData(
                              latitude: (AppHelpers.getInitialLatitude() ??
                                  AppConstants.demoLatitude),
                              longitude: (AppHelpers.getInitialLongitude() ??
                                  AppConstants.demoLongitude),
                            ),
                            title: AppHelpers.getAppAddressName()),
                      );
                      //ref.read(homeProvider.notifier).setAddress();
                    });
              }),
            ),
          ],
        )
      ],
    );
  }
}
