import 'dart:io';
import 'package:flutter/material.dart';
import 'package:flutter_remix/flutter_remix.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:image_picker/image_picker.dart';

import '../../../../../application/profile/profile_provider.dart';
import '../../../../../infrastructure/services/app_helpers.dart';
import '../../../../../infrastructure/services/tr_keys.dart';
import '../../../../component/helper/blur_wrap.dart';
import '../../../../styles/style.dart';

class SetBackgroundImage extends ConsumerWidget {
  const SetBackgroundImage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context , ref) {
    final state = ref.watch(profileProvider);
    final event = ref.read(profileProvider.notifier);
    return Container(
      height: 180.h,
      width: double.infinity,
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.circular(16.r),
      ),
      child: state.bgImage.isNotEmpty
          ? Stack(
        children: [
          SizedBox(
            height: 180.h,
            width: double.infinity,
            child: ClipRRect(
              borderRadius: BorderRadius.circular(16.r),
              child: Image.file(
                File(state.bgImage),
                fit: BoxFit.cover,
              ),
            ),
          ),
          Positioned(
            top: 12.h,
            right: 16.w,
            child: Row(
              children: [
                InkWell(
                  onTap: () async {
                    XFile? file;
                    try {
                      file = await ImagePicker()
                          .pickImage(source: ImageSource.gallery);
                    } catch (ex) {
                      debugPrint('===> trying to select image $ex');
                    }
                    if (file != null) {
                      event.setBgImage(file.path);
                    }
                  },
                  child: BlurWrap(
                    radius: BorderRadius.circular(20.r),
                    child: Container(
                      height: 40.r,
                      width: 40.r,
                      decoration: BoxDecoration(
                        shape: BoxShape.circle,
                        color: Style.white.withOpacity(0.15),
                      ),
                      child: const Icon(
                        FlutterRemix.image_add_fill,
                        color: Style.white,
                      ),
                    ),
                  ),
                ),
                10.horizontalSpace,
                InkWell(
                  onTap: () {
                    event.setBgImage("");
                  },
                  child: BlurWrap(
                    radius: BorderRadius.circular(20.r),
                    child: Container(
                      height: 40.r,
                      width: 40.r,
                      decoration: BoxDecoration(
                        shape: BoxShape.circle,
                        color: Style.white.withOpacity(0.15),
                      ),
                      child: const Icon(
                        FlutterRemix.delete_bin_fill,
                        color: Style.white,
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ],
      )
          : InkWell(
        onTap: () async {
          XFile? file;
          try {
            file = await ImagePicker()
                .pickImage(source: ImageSource.gallery);
          } catch (ex) {
            debugPrint('===> trying to select image $ex');
          }
          if (file != null) {
            event.setBgImage(file.path);
          }
        },
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Icon(
              FlutterRemix.upload_cloud_2_line,
              size: 42.r,
              color: Style.greenColor,
            ),
            16.verticalSpace,
            Text(
              AppHelpers.trans(TrKeys.balance),
              style: Style.interSemi(
                size: 14,
                color: Style.blackColor,
                letterSpacing: -0.3,
              ),
            ),
            Text(
              AppHelpers.trans(TrKeys.recommendedSize),
              style: Style.interRegular(
                size: 14,
                color: Style.blackColor,
                letterSpacing: -0.3,
              ),
            )
          ],
        ),
      ),
    );
  }
}
